/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Address Object,     *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Address Object will not function without a valid           *
#*      			  license string 			          	   *
#************************************************************* */

set pagesize 1000;

truncate table log;

declare
  ao pls_integer;
  zo pls_integer;
  bno varchar2(1000);
  val varchar2(1000);
  ok integer;
  a float;
  b float;
  c float;
  d float;
  dx double precision;
  bearing double precision;
begin
  insert into log values('starting');
  commit;

  zo := mdZipCreate();
  insert into log values('created mdZip object');
  commit;

  ok := mdZipSetLicenseString(zo, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdZipGetBuildNumber(zo);
  insert into log values('build number= ' || bno);
  commit;

  ok := mdZipInitialize(zo, 'PATH', 'PATH', 'PATH');
  insert into log values('init datafiles: error=' || ok);
  commit;

  /* test returning values by address */
  ok := mdZipGetSCFArea(zo, '926', a, b, c, d);
  insert into log values('get scf area: ok=' || ok);
  insert into log values(to_char(a, '999999.9999'));
  insert into log values(to_char(b, '999999.9999'));
  insert into log values(to_char(c, '999999.9999'));
  insert into log values(to_char(d, '999999.9999'));
  commit;

  /* test iteratitive interface to zip */
  ok := mdZipFindZip(zo, '10012', 0);
  while ok = 1
  loop
    insert into log values (
      mdZipGetState(zo) || ' ' || 
      mdZipGetZip(zo) ||  ' ' ||
      mdZipGetZipType(zo) || ' ' ||
      mdZipGetLastLineNumber(zo) || ' ' ||
      mdZipGetLastLineIndicator(zo) || ' ' ||
      mdZipGetCity(zo));
    commit;

    ok := mdZipFindZipNext(zo);
  end loop;

  /* test odd dx/heading function, los angeles to manhattan */
  dx := mdZipComputeDistance(zo, 
    34.0522342, -118.2436849, 40.77382953, -73.97129058);
  insert into log values(to_char(dx, '999999.9999') || ' miles');
  commit;

  bearing := mdZipComputeBearing(zo,
    34.0522342, -118.2436849, 40.77382953, -73.97129058);
  insert into log values(to_char(bearing, '999999.9999') || ' degrees');
  commit;

  mdZipDestroy(zo);
  insert into log values('destroyed mdZip object');
  commit;

end;
.
run

select * from log;
